<?php
include 'index.php';
?>
<section class="pc-container">
    <div class="pc-content">
        <div class="row">
            <div class="mb-4 d-flex justify-content-between align-items-center">
                <h2 class="mb-0">Data Pengguna</h2>
                <button class="btn btn-success rounded" data-bs-toggle="modal" data-bs-target="#addPenggunaModal">
                    <i class="ti ti-plus"></i> Tambah Pengguna
                </button>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Daftar Pengguna</h5>
                        <small>Kelola data pengguna sistem</small>
                    </div>
                    <div class="card-body">
                        <div class="dt-responsive">
                            <table id="dom-jqry" class="table table-striped table-bordered nowrap">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Username</th>
                                        <th>Email</th>
                                        <th>No HP</th>
                                        <th>Role</th>
                                        <th class="text-center">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $query = "SELECT * FROM users ORDER BY id_user DESC";
                                    $result = mysqli_query($conn, $query);
                                    $no = 1;
                                    while ($row = mysqli_fetch_assoc($result)) {
                                        // Badge color berdasarkan role
                                        $badge_class = '';
                                        switch($row['role']) {
                                            case 'admin':
                                                $badge_class = 'bg-danger';
                                                break;
                                            case 'apoteker':
                                                $badge_class = 'bg-primary';
                                                break;
                                            case 'petugas':
                                                $badge_class = 'bg-success';
                                                break;
                                            case 'kepala_puskesmas':
                                                $badge_class = 'bg-warning';
                                                break;
                                            default:
                                                $badge_class = 'bg-secondary';
                                        }
                                    ?>
                                    <tr>
                                        <td><?= $no++ ?></td>
                                        <td><?= $row['username'] ?></td>
                                        <td><?= $row['email'] ?></td>
                                        <td><?= $row['nohp'] ?></td>
                                        <td><span class="badge <?= $badge_class ?>"><?= ucfirst(str_replace('_', ' ', $row['role'])) ?></span></td>
                                        <td class="text-center">
                                            <button class="btn btn-info btn-sm" data-bs-toggle="modal" data-bs-target="#detailPenggunaModal<?php echo $row['id_user']; ?>" title="Detail">
                                                <i class="ti ti-eye"></i>
                                            </button>
                                            <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#editPenggunaModal<?php echo $row['id_user']; ?>" title="Edit">
                                                <i class="ti ti-edit"></i>
                                            </button>
                                            <button class="btn btn-secondary btn-sm" data-bs-toggle="modal" data-bs-target="#resetPasswordModal<?php echo $row['id_user']; ?>" title="Reset Password">
                                                <i class="ti ti-key"></i>
                                            </button>
                                            <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deletePenggunaModal<?php echo $row['id_user']; ?>" title="Hapus">
                                                <i class="ti ti-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Modal Tambah Pengguna -->
<div class="modal fade" id="addPenggunaModal" tabindex="-1" aria-labelledby="addPenggunaModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addPenggunaModalLabel">Tambah Pengguna</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="addPenggunaForm" action="tambahpengguna.php" method="POST">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="username" class="form-label">Username</label>
                                <input type="text" class="form-control" id="username" name="username" placeholder="Username" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" class="form-control" id="email" name="email" placeholder="email@example.com" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <input type="password" class="form-control" id="password" name="password" placeholder="Minimal 6 karakter" required>
                                <small class="text-muted">Password minimal 6 karakter</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="nohp" class="form-label">No HP</label>
                                <input type="text" class="form-control" id="nohp" name="nohp" placeholder="08xxxxxxxxxx" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="role" class="form-label">Role</label>
                                <select class="form-select" id="role" name="role" required>
                                    <option value="">Pilih Role</option>
                                    <option value="admin">Admin</option>
                                    <option value="apoteker">Apoteker</option>
                                    <option value="petugas">Petugas</option>
                                    <option value="kepala_puskesmas">Kepala Puskesmas</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Tutup</button>
                    <button type="submit" class="btn btn-success" name="tambah">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
    $query = "SELECT * FROM users ORDER BY id_user DESC";
    $result = mysqli_query($conn, $query);
    while ($row = mysqli_fetch_assoc($result)) {
?>

<!-- Modal Detail Pengguna -->
<div class="modal fade" id="detailPenggunaModal<?php echo $row['id_user']; ?>" tabindex="-1" aria-labelledby="detailPenggunaModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="detailPenggunaModalLabel">Detail Pengguna</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <table class="table table-borderless">
                    <tr>
                        <th width="35%">Username</th>
                        <td>: <?php echo $row['username']; ?></td>
                    </tr>
                    <tr>
                        <th>Email</th>
                        <td>: <?php echo $row['email']; ?></td>
                    </tr>
                    <tr>
                        <th>No HP</th>
                        <td>: <?php echo $row['nohp']; ?></td>
                    </tr>
                    <tr>
                        <th>Role</th>
                        <td>: <?php echo ucfirst(str_replace('_', ' ', $row['role'])); ?></td>
                    </tr>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Edit Pengguna -->
<div class="modal fade" id="editPenggunaModal<?php echo $row['id_user']; ?>" tabindex="-1" aria-labelledby="editPenggunaModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editPenggunaModalLabel">Edit Pengguna</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="editPenggunaForm" action="editpengguna.php" method="POST">
                <input type="hidden" name="id_user" value="<?php echo $row['id_user']; ?>">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_username<?php echo $row['id_user']; ?>" class="form-label">Username</label>
                                <input type="text" class="form-control" id="edit_username<?php echo $row['id_user']; ?>" name="username" value="<?php echo $row['username']; ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_email<?php echo $row['id_user']; ?>" class="form-label">Email</label>
                                <input type="email" class="form-control" id="edit_email<?php echo $row['id_user']; ?>" name="email" value="<?php echo $row['email']; ?>" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_nohp<?php echo $row['id_user']; ?>" class="form-label">No HP</label>
                                <input type="text" class="form-control" id="edit_nohp<?php echo $row['id_user']; ?>" name="nohp" value="<?php echo $row['nohp']; ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_role<?php echo $row['id_user']; ?>" class="form-label">Role</label>
                                <select class="form-select" id="edit_role<?php echo $row['id_user']; ?>" name="role" required>
                                    <option value="admin" <?php echo $row['role'] == 'admin' ? 'selected' : ''; ?>>Admin</option>
                                    <option value="apoteker" <?php echo $row['role'] == 'apoteker' ? 'selected' : ''; ?>>Apoteker</option>
                                    <option value="petugas" <?php echo $row['role'] == 'petugas' ? 'selected' : ''; ?>>Petugas</option>
                                    <option value="kepala_puskesmas" <?php echo $row['role'] == 'kepala_puskesmas' ? 'selected' : ''; ?>>Kepala Puskesmas</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="alert alert-info">
                        <i class="ti ti-info-circle"></i> Password tidak akan berubah. Gunakan fitur Reset Password untuk mengubah password.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Tutup</button>
                    <button type="submit" class="btn btn-warning" name="edit">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Reset Password -->
<div class="modal fade" id="resetPasswordModal<?php echo $row['id_user']; ?>" tabindex="-1" aria-labelledby="resetPasswordModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resetPasswordModalLabel">Reset Password</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="resetPasswordForm" action="resetpassword.php" method="POST">
                <input type="hidden" name="id_user" value="<?php echo $row['id_user']; ?>">
                <div class="modal-body">
                    <p>Reset password untuk pengguna <strong><?php echo $row['username']; ?></strong>?</p>
                    <div class="mb-3">
                        <label for="reset_password<?php echo $row['id_user']; ?>" class="form-label">Password Baru</label>
                        <input type="password" class="form-control" id="reset_password<?php echo $row['id_user']; ?>" name="password" placeholder="Minimal 6 karakter" required>
                        <small class="text-muted">Password minimal 6 karakter</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-secondary" name="reset">Reset Password</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Hapus Pengguna -->
<div class="modal fade" id="deletePenggunaModal<?php echo $row['id_user']; ?>" tabindex="-1" aria-labelledby="deletePenggunaModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deletePenggunaModalLabel">Konfirmasi Hapus</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="deletePenggunaForm" action="hapuspengguna.php" method="POST">
                <input type="hidden" name="id_user" value="<?php echo $row['id_user']; ?>">
                <div class="modal-body">
                    <p>Apakah Anda yakin ingin menghapus pengguna <strong><?php echo $row['username']; ?></strong>?</p>
                    <div class="alert alert-warning">
                        <i class="ti ti-alert-triangle"></i> Data yang dihapus tidak dapat dikembalikan!
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-danger" name="hapus">Hapus</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php } ?>

<?php include 'footer.php'; ?>